set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      71.278070,
      NULL,
      NULL,
      1,
      '411314',
      1,
      ' 8-18-1990',
      13.664592,
      NULL,
      1.535705,
      NULL,
      11,
      0.740602,
      0,
      1.760432,
      NULL,
      1.330109,
      0.986540,
      1.698525,
      0.393741,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0.560261,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.894954,
      NULL,
      NULL,
      1.136118,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635790,
      0,
      1,
      1,
      1.759741,
      1.024020,
      0.561569,
      1.212561,
      0.701647,
      0,
      NULL,
      1.671705,
      NULL,
      0.778939,
      0,
      1.461863,
      0.550466,
      0.830801,
      0,
      NULL,
      0.046156,
      1,
      1,
      0.445051,
      0,
      NULL,
      1.706563,
      1,
      1,
      0,
      NULL,
      1.307011,
      1.956660,
      0,
      0.946520,
      0.440960,
      0.834717,
      5,
      4.422825,
      5.786932,
      7,
      0,
      1.140120,
      NULL,
      1,
      0,
      0.347295,
      0.082793,
      0,
      NULL,
      NULL,
      2,
      1.235078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830815,
      NULL,
      0,
      1,
      0.315309,
      1.588454,
      1.667428,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896207,
      NULL,
      5.377022,
      0.354171,
      NULL,
      4,
      2.859819,
      3,
      NULL,
      1,
      1.209175,
      0.852589,
      2.687107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.314092,
      NULL,
      0,
      0,
      1.213003,
      NULL,
      NULL,
      NULL,
      1.367379,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.678034,
      NULL,
      1,
      0.452621,
      0.084050,
      1.404586,
      3.810957,
      1,
      1,
      0.217757,
      1,
      0,
      1,
      0.638365,
      1.417850,
      0.300890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.540808,
      '3402',
      '',
      NULL,
      0.431801,
      '00202',
      NULL,
      NULL,
      2,
      '3144',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


