set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '3114330',
      1,
      4,
      0,
      1,
      '032400',
      1.761624,
      ' 1-21-1975',
      20.103764,
      NULL,
      1.504670,
      NULL,
      4.354643,
      1,
      0.502397,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      1.484331,
      0.638561,
      0,
      0,
      1,
      1.163076,
      1,
      2.748178,
      1.203028,
      0,
      1.824580,
      0.751988,
      0.159702,
      NULL,
      0,
      0.467156,
      1,
      0.597112,
      0,
      NULL,
      NULL,
      0.889266,
      NULL,
      NULL,
      0.361481,
      NULL,
      0.496339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396683,
      0.716687,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974381,
      0,
      0.510824,
      1,
      1.786902,
      3.034581,
      0.715720,
      0,
      0,
      4.180482,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.464078,
      0,
      NULL,
      NULL,
      NULL,
      1.399109,
      0,
      NULL,
      1,
      1.527755,
      0.972609,
      0.843733,
      1,
      0,
      1.640398,
      1,
      NULL,
      1.490011,
      1,
      0.639546,
      0.600157,
      1.111275,
      1.311561,
      2.651593,
      5,
      0.872790,
      NULL,
      0,
      5.943097,
      2.278715,
      0.825765,
      1,
      1.697926,
      0.591566,
      NULL,
      NULL,
      9.428125,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453991,
      1,
      0,
      1.697343,
      0,
      1,
      1.600093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711189,
      1.423891,
      NULL,
      2.982836,
      NULL,
      6,
      NULL,
      2.710632,
      0.291834,
      1,
      NULL,
      0.342510,
      0.029916,
      0,
      2.426950,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.699831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040000,
      NULL,
      3,
      NULL,
      1,
      1.209472,
      1,
      NULL,
      0,
      3.054748,
      0.744027,
      NULL,
      0,
      0.452701,
      0.830628,
      1.268825,
      1.603717,
      1,
      0,
      1.128988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.272363,
      '2141',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '3042',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


