set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '404',
      '14',
      14,
      NULL,
      NULL,
      126.375332,
      4,
      0.222091,
      0,
      '031032',
      4,
      NULL,
      NULL,
      27.509794,
      0.085416,
      NULL,
      3,
      NULL,
      1.006602,
      1.894200,
      2,
      1.275045,
      1.209659,
      1.792079,
      0,
      NULL,
      NULL,
      NULL,
      1.113702,
      NULL,
      1.258549,
      3,
      5,
      1,
      2.271001,
      1.433708,
      0.366461,
      0.733096,
      2.666102,
      1,
      3.300467,
      0,
      NULL,
      1.567617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.504525,
      1,
      1,
      1.293123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      1.393105,
      0.634090,
      0,
      3,
      5.770207,
      NULL,
      0.940347,
      4,
      1.596368,
      1,
      1,
      1.600825,
      0,
      NULL,
      0,
      1.629005,
      NULL,
      0,
      1,
      1,
      0,
      1.249384,
      1.126784,
      1.139226,
      1,
      0.761351,
      1,
      0,
      0.616100,
      0.108678,
      0.895533,
      NULL,
      NULL,
      0.993692,
      NULL,
      0.992881,
      0.435987,
      1.395155,
      3,
      1,
      0,
      1.323990,
      0.832675,
      1.960005,
      1,
      2,
      0.477379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297545,
      0.640426,
      1,
      0,
      1.714371,
      1.359313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      3,
      7.817697,
      0.693820,
      NULL,
      0.819195,
      0,
      0.163993,
      1.516312,
      1.777049,
      0.404846,
      2,
      1.352981,
      1.253498,
      0,
      0.517059,
      NULL,
      NULL,
      2.313003,
      2,
      2.701719,
      1,
      NULL,
      NULL,
      1.612136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.829477,
      2.611064,
      0,
      3,
      0,
      0.772740,
      NULL,
      3.501652,
      1.984154,
      0.545278,
      NULL,
      1.359929,
      NULL,
      0.526313,
      1,
      NULL,
      0.636431,
      1.290313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.491077,
      '03343',
      '',
      '',
      NULL,
      '30403',
      '',
      '',
      1,
      '2434',
      '',
      NULL,
      5.479282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


