set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '10',
      31,
      20.616998,
      '2043301',
      NULL,
      NULL,
      2.926043,
      2,
      '204441',
      0,
      ' 5-21-2002',
      39,
      7,
      1.592530,
      NULL,
      1.428120,
      3,
      NULL,
      0,
      1,
      1.529494,
      2.351175,
      0.610412,
      1,
      NULL,
      7.410686,
      1,
      NULL,
      4.906960,
      0,
      1,
      7,
      1.936034,
      3,
      3.274505,
      2,
      1.869837,
      NULL,
      0,
      1.216097,
      NULL,
      0.112975,
      0.563048,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.433797,
      1,
      0,
      3.505425,
      0.015484,
      0,
      0.447675,
      0.195554,
      NULL,
      0,
      0.963155,
      NULL,
      NULL,
      0.188314,
      1.790633,
      1,
      0.055830,
      1,
      1.389497,
      1.663170,
      NULL,
      0.801903,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.670023,
      NULL,
      NULL,
      NULL,
      1.774817,
      NULL,
      1,
      NULL,
      1.823351,
      1,
      NULL,
      NULL,
      1.300647,
      1.938349,
      2.961197,
      1,
      2,
      NULL,
      0.548803,
      1.798268,
      NULL,
      1.109815,
      NULL,
      0,
      1,
      0.937326,
      NULL,
      1.428570,
      1,
      1,
      1,
      4,
      1.176818,
      NULL,
      1,
      0,
      NULL,
      5,
      NULL,
      1.161158,
      2.718812,
      6,
      0,
      5.644551,
      6,
      8,
      8,
      2,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.860118,
      0.635410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389440,
      1.375586,
      0,
      1,
      0,
      0.017272,
      0,
      0.940818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      2.010760,
      0.352612,
      0.040073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.093730,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      2,
      1,
      0.068972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.511139,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      0.360086,
      3,
      NULL,
      NULL,
      0.408950,
      0.284250,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '',
      NULL,
      0.844350,
      '13101',
      NULL,
      '',
      5.604047,
      NULL,
      '3313',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


