set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '23',
      37,
      6.535843,
      NULL,
      NULL,
      6,
      2,
      3,
      '042204',
      0,
      ' 5- 5-1987',
      31.879550,
      54.407906,
      1,
      NULL,
      11,
      NULL,
      1,
      0,
      0.541095,
      1.146491,
      1,
      1,
      0,
      0,
      11,
      0.439237,
      1.033409,
      0,
      1,
      0,
      5.052424,
      0,
      5,
      7.340217,
      1.346295,
      0,
      7.274637,
      1,
      NULL,
      NULL,
      0,
      0.471255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.526553,
      1.955806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      0,
      1,
      NULL,
      1.463716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.052525,
      1,
      1,
      0,
      0,
      0,
      1.897988,
      0,
      0,
      NULL,
      0.205461,
      1.329705,
      0.603544,
      1,
      0,
      0.389344,
      NULL,
      1,
      0,
      NULL,
      0.181128,
      0,
      1.386004,
      0.078817,
      0,
      1,
      0,
      NULL,
      1.272052,
      1,
      0.033650,
      0.633203,
      1,
      1,
      NULL,
      0.586236,
      0.183019,
      5,
      6,
      NULL,
      7,
      1,
      NULL,
      2,
      2.811164,
      0.242639,
      0.382566,
      0,
      1,
      1.829596,
      1,
      2,
      1.072248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.448003,
      NULL,
      NULL,
      0.723012,
      0,
      1.069379,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.096895,
      1,
      1.297290,
      1.712297,
      1,
      0.523784,
      2.020364,
      3,
      NULL,
      3.790246,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.919440,
      3.442847,
      3.167975,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323135,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      2.310809,
      3,
      1.569841,
      3,
      NULL,
      1.507356,
      0.809027,
      1,
      1.983628,
      1.535367,
      1,
      NULL,
      1.959812,
      1.335337,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      0,
      '21001',
      NULL,
      NULL,
      2,
      '3404',
      '2202',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


