set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      '23',
      20,
      18.116323,
      '4040242',
      162.960785,
      5,
      NULL,
      2,
      '422230',
      2.892017,
      '10- 4-1983',
      38,
      38.478356,
      1,
      NULL,
      14.547979,
      1.858416,
      1.801512,
      1,
      0,
      0.125453,
      1,
      0.248531,
      3,
      NULL,
      6,
      1,
      NULL,
      0.648724,
      0,
      0.112453,
      1.962374,
      NULL,
      2.928976,
      NULL,
      8.575175,
      0,
      7,
      NULL,
      1.468256,
      1.552752,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.955081,
      NULL,
      1.353573,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      7,
      0,
      2,
      0.578808,
      0,
      NULL,
      NULL,
      1.441681,
      NULL,
      NULL,
      NULL,
      1.729629,
      3,
      0,
      NULL,
      0.484464,
      NULL,
      0,
      1,
      0.402629,
      1,
      1.966656,
      1.087437,
      NULL,
      1,
      1.967074,
      1,
      1.324815,
      0,
      NULL,
      0.884862,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      5.759443,
      2.818346,
      0.268625,
      3.664711,
      0.462689,
      NULL,
      0.516068,
      4,
      NULL,
      5,
      NULL,
      2.312040,
      6.010300,
      4.933419,
      1.362721,
      1.121532,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.917127,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8,
      0,
      0.477901,
      0.136679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.969497,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.071672,
      3,
      1.069126,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.848706,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313677,
      NULL,
      3.556237,
      0.862369,
      1.323827,
      0,
      3.660546,
      3,
      1.520168,
      3.313975,
      1,
      0,
      0,
      0,
      0.234054,
      0.369588,
      1.232082,
      0.278907,
      0,
      1.677199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '41434',
      NULL,
      '',
      NULL,
      '42442',
      NULL,
      '',
      4.852265,
      '4241',
      '4104',
      '',
      4.276127,
      2,
      2.593231,
      2.606373,
      2.711752,
      NULL,
      NULL,
      2,
      0);
commit;
end;
/


