set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      '31010203',
      3.463977,
      39.843172,
      '3420324',
      55.901769,
      4,
      3,
      1,
      '142112',
      0.715110,
      ' 6-12-1979',
      0.811034,
      62.508569,
      1,
      NULL,
      13,
      NULL,
      NULL,
      1.648417,
      1,
      1.899463,
      0.558096,
      1,
      NULL,
      NULL,
      3.501950,
      0.714268,
      0.368132,
      2,
      3.789502,
      2.755851,
      NULL,
      0,
      10,
      4,
      1.259826,
      0,
      1,
      NULL,
      0.859135,
      1.660385,
      1.469772,
      1.893063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.985417,
      0,
      5.859571,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.600932,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      1.958766,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.334846,
      0.098619,
      NULL,
      0,
      NULL,
      1.240493,
      0,
      NULL,
      1,
      0.300759,
      0,
      1,
      NULL,
      5.929669,
      0.922933,
      0.823395,
      1,
      NULL,
      0.651717,
      3,
      1.668889,
      NULL,
      6,
      2.384669,
      NULL,
      2,
      6,
      3,
      2,
      8,
      1,
      0.287667,
      0.574717,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506607,
      NULL,
      7,
      1.962839,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.553335,
      1,
      1.021298,
      NULL,
      NULL,
      NULL,
      8,
      0,
      NULL,
      1.540208,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.105130,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787856,
      0.553138,
      0.445082,
      NULL,
      2.149302,
      1.627945,
      2.904831,
      NULL,
      0,
      1.423004,
      0,
      NULL,
      0.944999,
      NULL,
      1.256849,
      1,
      NULL,
      1.193385,
      1,
      1.683590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '14200',
      '',
      '',
      2.941140,
      '32033',
      '',
      '',
      5.671507,
      '2343',
      NULL,
      '',
      NULL,
      1,
      1.418272,
      NULL,
      0.959983,
      NULL,
      1.150236,
      2,
      3);
commit;
end;
/


