set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40311442',
      6,
      47,
      '1130243',
      21,
      6,
      1.554856,
      NULL,
      '001024',
      0,
      ' 8-20-2001',
      29.420121,
      4,
      NULL,
      NULL,
      11,
      1,
      1,
      0,
      3.500999,
      0.398814,
      1.262341,
      0.109465,
      0,
      1.845047,
      5.744833,
      0.422677,
      3,
      4.090366,
      8.009901,
      4,
      6.478939,
      NULL,
      5.604158,
      6,
      2,
      1,
      8,
      1,
      NULL,
      0.918104,
      1,
      NULL,
      NULL,
      NULL,
      1.453922,
      NULL,
      NULL,
      6,
      NULL,
      0,
      3.480454,
      0.013604,
      0.839059,
      1.438412,
      1.721625,
      1,
      1,
      0.963558,
      0.310763,
      0,
      NULL,
      1.038513,
      1,
      1,
      1,
      NULL,
      0.296234,
      0,
      0,
      6.932384,
      0,
      1,
      1.250752,
      NULL,
      NULL,
      NULL,
      1.124696,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.566883,
      4,
      1.196780,
      1.758934,
      0.770636,
      1,
      1.746615,
      1.179909,
      1,
      1.692547,
      1,
      NULL,
      NULL,
      0,
      1.045772,
      1.356955,
      NULL,
      NULL,
      1.072045,
      0,
      0.326221,
      NULL,
      0,
      0,
      0.020148,
      2.002282,
      NULL,
      0.431750,
      0,
      NULL,
      NULL,
      4.036409,
      1,
      NULL,
      NULL,
      3.261923,
      2,
      7,
      7,
      4.009690,
      9,
      0,
      1.103752,
      NULL,
      1,
      NULL,
      0,
      1.669263,
      3.543505,
      0.330838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481727,
      0,
      1,
      0,
      0.940822,
      1,
      NULL,
      1.200730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.093514,
      6,
      2.328822,
      0.655962,
      0.599219,
      NULL,
      1,
      0.804299,
      NULL,
      1.181290,
      NULL,
      NULL,
      NULL,
      7.499553,
      0,
      6.595355,
      NULL,
      4.931656,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627237,
      0.866241,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023371,
      2.930520,
      0,
      3,
      3.347091,
      1,
      3,
      3.723526,
      0,
      NULL,
      1.093029,
      0.999921,
      0.309377,
      1,
      0,
      NULL,
      1.852123,
      0.882254,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      '',
      1.657784,
      '',
      '',
      '',
      0,
      '0024',
      NULL,
      '',
      1,
      NULL,
      2.708677,
      NULL,
      2.962120,
      3.844476,
      2.592244,
      NULL,
      NULL);
commit;
end;
/


