set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23133031',
      29.986541,
      6.540869,
      '2021234',
      NULL,
      5,
      NULL,
      2,
      '010223',
      4.775129,
      ' 0-14-1994',
      12,
      32,
      1.765551,
      NULL,
      15,
      NULL,
      1,
      1.616647,
      0.749106,
      0,
      1,
      0,
      1.546638,
      1,
      10.781923,
      1.046693,
      1.278626,
      NULL,
      10.207724,
      NULL,
      NULL,
      0,
      1.446759,
      NULL,
      0.230721,
      0.066749,
      0.677894,
      0,
      5.219000,
      3.599280,
      5.067135,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.525758,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.458115,
      0,
      1,
      0,
      2,
      1,
      0.171014,
      NULL,
      NULL,
      1.754374,
      NULL,
      NULL,
      0,
      1.745447,
      NULL,
      1.742871,
      0,
      1.549598,
      0,
      0.570362,
      0.314353,
      0,
      1.524717,
      1,
      NULL,
      1,
      1.943567,
      0,
      0,
      0.958569,
      0,
      NULL,
      1.351907,
      1.087338,
      NULL,
      NULL,
      1.110493,
      NULL,
      0.614300,
      NULL,
      3.889515,
      0,
      0,
      1,
      0,
      0.421246,
      2,
      1.498483,
      0,
      2.085786,
      3.096534,
      4,
      NULL,
      4,
      9.280846,
      3.117087,
      10.561391,
      NULL,
      1.509603,
      NULL,
      1,
      0.092497,
      0,
      3,
      0.772756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.232225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.322502,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046592,
      0.137540,
      NULL,
      NULL,
      NULL,
      2.813320,
      1.618609,
      NULL,
      3.485871,
      4,
      NULL,
      NULL,
      1.939576,
      NULL,
      NULL,
      0.011727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108354,
      2,
      NULL,
      2,
      2.850498,
      1,
      1,
      2,
      1,
      2.676516,
      1,
      NULL,
      0.093715,
      NULL,
      0,
      NULL,
      1.347303,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693465,
      '22201',
      NULL,
      NULL,
      0.395302,
      '',
      '',
      '',
      5.882624,
      '2144',
      '4144',
      '',
      0,
      5,
      3,
      3.269535,
      2.076469,
      1.463191,
      0,
      0.070282,
      0.495561);
commit;
end;
/


