set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '34420130',
      11.356501,
      41.427206,
      '2320442',
      205,
      5,
      NULL,
      1,
      NULL,
      6.181891,
      ' 7- 9-1977',
      12.592027,
      27.042472,
      1.353227,
      NULL,
      7,
      0.991696,
      NULL,
      0.923679,
      0.147475,
      0.353507,
      NULL,
      NULL,
      NULL,
      0.575886,
      7,
      NULL,
      4.529099,
      4.608254,
      9.587109,
      6.311550,
      4,
      1.632562,
      8,
      0,
      NULL,
      NULL,
      1.673372,
      0,
      3,
      0.915785,
      3.989572,
      0.153414,
      NULL,
      NULL,
      0.864964,
      NULL,
      NULL,
      0.682244,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.361320,
      1.398691,
      0.657009,
      0,
      1,
      2,
      1.678272,
      NULL,
      NULL,
      NULL,
      1.462523,
      NULL,
      NULL,
      1.474760,
      1,
      1.795112,
      0,
      1,
      1.202987,
      0.458980,
      0,
      0,
      0,
      NULL,
      1.488041,
      0.288086,
      NULL,
      1.372131,
      1.460943,
      NULL,
      NULL,
      0.970145,
      NULL,
      0.404308,
      1,
      1,
      1.990762,
      0.335777,
      0.262526,
      0,
      0,
      4,
      NULL,
      1,
      0.916356,
      1,
      NULL,
      4.224799,
      1.851339,
      0,
      4,
      4,
      5.186668,
      3,
      1,
      3.023592,
      8.392599,
      3.542486,
      0.085893,
      NULL,
      2.763942,
      1.471826,
      1.339413,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925657,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      3.289671,
      3.882068,
      0.249701,
      0,
      1.784215,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.607892,
      5.813656,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1.110643,
      7.479240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.150104,
      0,
      1,
      0,
      1.067896,
      0,
      1,
      0.335436,
      NULL,
      NULL,
      1.497657,
      NULL,
      NULL,
      0.365129,
      1,
      0.323096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '01134',
      '',
      '',
      1.418676,
      '',
      '',
      '',
      5,
      '3044',
      '2401',
      '',
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      0,
      3,
      3.805714);
commit;
end;
/


