set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      NULL,
      29,
      71,
      '0114101',
      216.329934,
      NULL,
      1.599845,
      0,
      '320243',
      2.219670,
      ' 9-15-1996',
      26.628948,
      45.202087,
      NULL,
      NULL,
      14,
      0,
      0,
      0,
      3.094883,
      0.721469,
      0,
      1,
      2.667374,
      1,
      0,
      0.772679,
      1.581270,
      NULL,
      NULL,
      0.798595,
      0.857140,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      NULL,
      5.401104,
      3,
      3,
      0.845326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.021060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.374175,
      NULL,
      1.033538,
      2,
      1,
      1,
      2,
      0.909423,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.357715,
      NULL,
      0,
      1.015040,
      1,
      1.457332,
      1.547438,
      NULL,
      1.252531,
      1,
      1,
      0.123199,
      NULL,
      0,
      0.667263,
      0,
      1,
      1.895737,
      NULL,
      NULL,
      1,
      1,
      1,
      1.865156,
      0,
      1.787369,
      1,
      1.915476,
      NULL,
      0.622964,
      1,
      1.283818,
      0.279440,
      1.669930,
      0,
      1,
      NULL,
      1.085167,
      NULL,
      6,
      NULL,
      0.798630,
      11.373687,
      NULL,
      0,
      NULL,
      1.259702,
      0,
      0.245387,
      1.525596,
      3.091413,
      1.269196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.066769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.909425,
      1,
      1.220065,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.948472,
      3.465233,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      2,
      4,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.203504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.186096,
      3.659725,
      1,
      NULL,
      NULL,
      0.647424,
      2,
      NULL,
      1.420132,
      NULL,
      0.730099,
      NULL,
      NULL,
      0.065050,
      1,
      0.058226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.247516,
      '43131',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '2014',
      '2044',
      '',
      0,
      0,
      0,
      NULL,
      NULL,
      3.181877,
      0.154948,
      3.033961,
      NULL);
commit;
end;
/


