set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      '34104342',
      36.631744,
      77.935507,
      '4330213',
      263,
      3,
      2,
      1,
      '433104',
      NULL,
      ' 8-23-1992',
      32.153079,
      3.277206,
      0,
      NULL,
      14.009330,
      NULL,
      0.282274,
      0.877068,
      NULL,
      1.346268,
      1,
      0.717824,
      0,
      0,
      4,
      0,
      1,
      6.620104,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      7,
      1,
      7.987109,
      NULL,
      NULL,
      0.002046,
      NULL,
      1,
      0.629707,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.517550,
      6.399338,
      0,
      3.975822,
      NULL,
      0.829967,
      2,
      NULL,
      0.314617,
      NULL,
      0.200865,
      NULL,
      0.188015,
      NULL,
      0.496869,
      3.520850,
      NULL,
      0,
      NULL,
      1.344360,
      3.139444,
      0.271458,
      1,
      NULL,
      0,
      1,
      1.757250,
      NULL,
      NULL,
      1.425486,
      NULL,
      NULL,
      1.867942,
      NULL,
      0,
      0.750332,
      1,
      NULL,
      NULL,
      NULL,
      1.908537,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0.165622,
      NULL,
      1.226329,
      NULL,
      0.976285,
      1.254597,
      0,
      0,
      1,
      1.083032,
      0.391903,
      0,
      1,
      NULL,
      NULL,
      0,
      0.049263,
      1,
      0.483409,
      NULL,
      0.549957,
      1.432270,
      3.424629,
      4.395069,
      0.342003,
      0,
      2.276027,
      5.538477,
      2,
      0.416405,
      NULL,
      1,
      0.025868,
      0,
      NULL,
      1.811187,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.165162,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.834541,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.280098,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1.955107,
      2,
      0.920367,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.934109,
      1.467532,
      0.788596,
      3,
      1.518819,
      2.993403,
      1.608453,
      1,
      1.734892,
      1.393896,
      0.768750,
      1,
      0.306745,
      0.913351,
      NULL,
      0.784044,
      NULL,
      0.323733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.252904,
      '24233',
      '',
      '',
      0.929238,
      NULL,
      '',
      '',
      4,
      '2204',
      '1432',
      NULL,
      NULL,
      NULL,
      1.718697,
      1.276555,
      3,
      NULL,
      0,
      2,
      2);
commit;
end;
/


