set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '021',
      '01102234',
      58,
      3.101819,
      NULL,
      48,
      NULL,
      NULL,
      NULL,
      '321141',
      2.934891,
      NULL,
      NULL,
      10,
      1,
      NULL,
      12,
      1.565191,
      1,
      NULL,
      NULL,
      1,
      2,
      0.685730,
      1,
      1,
      0.475165,
      1.052688,
      5.330811,
      3.251824,
      9,
      1,
      4.684589,
      2,
      6,
      NULL,
      2.565353,
      NULL,
      6.815912,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895970,
      NULL,
      NULL,
      1.011230,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435358,
      1.456673,
      0.045921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605696,
      1.231741,
      3.846701,
      NULL,
      0.732277,
      NULL,
      0.071641,
      0.082593,
      0.016552,
      NULL,
      0.499315,
      0,
      NULL,
      0,
      0.387804,
      1.685137,
      0,
      0.508224,
      0.627622,
      NULL,
      NULL,
      0.721090,
      0,
      NULL,
      0.868125,
      1,
      0.437934,
      0.584402,
      1.746761,
      0,
      1.321266,
      0,
      NULL,
      1.590887,
      0.814160,
      1.514710,
      1.616241,
      0.544774,
      NULL,
      NULL,
      2.549324,
      3.699244,
      5.982648,
      7,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      1.635400,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.656447,
      3.541518,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.888369,
      NULL,
      1.448671,
      NULL,
      NULL,
      NULL,
      5.249020,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.992913,
      NULL,
      NULL,
      0.156198,
      3.976510,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772622,
      0.262844,
      1.786255,
      1,
      3,
      NULL,
      2.977514,
      NULL,
      0,
      1,
      1,
      1.819846,
      0,
      0.523322,
      1,
      1.401454,
      0.081229,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.905611,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '0114',
      '',
      0,
      1,
      2,
      2.286082,
      NULL,
      0,
      3.648961,
      1.697445,
      NULL);
commit;
end;
/


