set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4134',
      '02201220',
      55,
      44.143980,
      NULL,
      304.805950,
      1,
      0,
      1,
      '443220',
      NULL,
      NULL,
      33.188064,
      32.822992,
      0,
      NULL,
      7.455736,
      NULL,
      0,
      0.779115,
      2.047039,
      1,
      0,
      1.763967,
      NULL,
      0,
      4.566960,
      1,
      NULL,
      1.057321,
      NULL,
      7,
      2,
      NULL,
      11.475651,
      5,
      9.877716,
      1,
      0,
      1,
      NULL,
      0.441067,
      NULL,
      1.071417,
      NULL,
      NULL,
      1.243301,
      NULL,
      NULL,
      0.279771,
      0.496507,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877196,
      0,
      0.815164,
      0.994685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612907,
      1.717813,
      0,
      1.371546,
      1.434593,
      0.350415,
      1,
      1,
      1,
      NULL,
      1,
      0.919930,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1.652039,
      0.905443,
      1,
      NULL,
      0.090909,
      1.392946,
      0.870213,
      0.416286,
      4,
      5.612727,
      1.863093,
      0.074107,
      1,
      0.334256,
      0,
      NULL,
      0.457518,
      NULL,
      5,
      3.521107,
      1.542888,
      NULL,
      1.157543,
      NULL,
      6,
      4.699457,
      7,
      NULL,
      1.020943,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.775242,
      1.032468,
      1,
      1,
      1.319351,
      0.803197,
      0.767783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733407,
      NULL,
      6.317902,
      NULL,
      2,
      5.110098,
      0,
      1.977205,
      3,
      3.273304,
      3,
      4.872086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.591468,
      4,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925381,
      3.385273,
      3,
      0.165104,
      3,
      NULL,
      1,
      1,
      0,
      3,
      3.424183,
      1.415979,
      2.757058,
      1.186636,
      0.463592,
      1.559804,
      0.752825,
      1.101250,
      0,
      1,
      NULL,
      0.657423,
      1.155177,
      0,
      1.418713,
      1.413574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '04024',
      '',
      '',
      0.471661,
      NULL,
      '',
      '',
      1.110076,
      '1043',
      '1021',
      '40301',
      NULL,
      11.772634,
      1.812253,
      0.202235,
      2,
      4.451970,
      0,
      3.272160,
      0.905241);
commit;
end;
/


