set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1113',
      '12414412',
      83.539190,
      66,
      '4341104',
      235.616085,
      1,
      3,
      1,
      '103241',
      5.741780,
      ' 7- 7-1997',
      32.605246,
      NULL,
      1.756915,
      NULL,
      3.964808,
      0.192739,
      NULL,
      0.032752,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      0.562386,
      3.286103,
      0.346379,
      7,
      NULL,
      2.457616,
      0.180158,
      4.580752,
      2.887968,
      0,
      1.171378,
      8,
      1,
      2.633917,
      4,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663253,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236478,
      0.972297,
      1.697979,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010030,
      NULL,
      1.381259,
      0,
      1.961842,
      NULL,
      0.398515,
      0.391913,
      0.083668,
      0,
      0,
      1,
      0,
      1,
      0.340976,
      NULL,
      NULL,
      NULL,
      0,
      1.136722,
      1,
      1,
      0,
      1,
      NULL,
      1,
      2.100101,
      3,
      0,
      1,
      1,
      0.745489,
      5.350475,
      1,
      1,
      NULL,
      1.208164,
      NULL,
      5.990928,
      0,
      2.564277,
      11,
      7.633563,
      3.269178,
      0,
      NULL,
      NULL,
      NULL,
      1.096384,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614490,
      0,
      NULL,
      0,
      NULL,
      1,
      0.108985,
      0.422188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.423197,
      2.043959,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.607502,
      2.012963,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.286513,
      NULL,
      3,
      4.570977,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1.187067,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.566490,
      2,
      0,
      2.350841,
      1,
      3.100000,
      0.374843,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1.937340,
      NULL,
      0.072837,
      1.113752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '03244',
      '',
      '',
      0.332403,
      NULL,
      '',
      '',
      NULL,
      '2040',
      '4040',
      '33420',
      0.226339,
      NULL,
      1.772220,
      0.041278,
      3,
      0,
      0.753345,
      2.063415,
      0);
commit;
end;
/


