set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41112003',
      90,
      41.694537,
      '2122012',
      186.704925,
      NULL,
      0.288508,
      2,
      '024433',
      NULL,
      ' 7- 6-1983',
      12.556922,
      10,
      1.858861,
      NULL,
      12.762787,
      0.542797,
      1.906654,
      0,
      3.072818,
      0,
      0.380691,
      1,
      1,
      1,
      10.905960,
      1,
      0,
      NULL,
      6.318149,
      NULL,
      6.334826,
      0.798721,
      7,
      0.959775,
      1,
      0,
      5,
      1,
      5,
      NULL,
      0.424671,
      0.070873,
      NULL,
      NULL,
      1.918092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.045984,
      3,
      4.570316,
      0,
      2,
      3.884632,
      NULL,
      NULL,
      NULL,
      0.600260,
      NULL,
      NULL,
      NULL,
      1.261164,
      0,
      0,
      0.599769,
      NULL,
      NULL,
      0.963303,
      0.459395,
      1.286547,
      1,
      0,
      0.272774,
      0.218060,
      0.447070,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0.768107,
      0.326969,
      1,
      1.546008,
      0.775284,
      0.790474,
      1.260028,
      0,
      1,
      0,
      1.119166,
      0.847282,
      1,
      1.002391,
      NULL,
      1.254388,
      7,
      2.757505,
      6.290238,
      2,
      0.772564,
      1.366468,
      9,
      6.332015,
      2,
      3.836505,
      1.955083,
      0,
      1,
      0.854945,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.105397,
      1.900071,
      0,
      1.214143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042065,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.042310,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.299144,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.169721,
      NULL,
      0.158969,
      2,
      2,
      1.191322,
      0,
      0.303781,
      1.120069,
      2.074574,
      1,
      0.253345,
      0,
      0,
      0.926761,
      1.440421,
      0,
      0.850110,
      1.412754,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844402,
      '24343',
      NULL,
      '',
      1.134490,
      '',
      '',
      '',
      NULL,
      '0012',
      '1141',
      '4433',
      4.438828,
      7,
      0,
      0.554544,
      2,
      2.854364,
      NULL,
      NULL,
      1.616120);
commit;
end;
/


