set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '04',
      10.537556,
      11.349805,
      '0410140',
      NULL,
      NULL,
      2.497169,
      3,
      '414434',
      NULL,
      '10-17-1993',
      0,
      51,
      0.141508,
      NULL,
      0.030396,
      NULL,
      2.386909,
      0.966912,
      1.613997,
      1.193887,
      1.924365,
      3.895828,
      1.753875,
      1.834345,
      3,
      0,
      1.183969,
      1.717234,
      1.432070,
      8.817702,
      0.485492,
      NULL,
      0.824700,
      1.859775,
      1.552931,
      1,
      NULL,
      1,
      NULL,
      0.203450,
      1.998876,
      0.679989,
      NULL,
      NULL,
      0.080437,
      NULL,
      NULL,
      0.628297,
      0,
      1.209372,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776241,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.137211,
      NULL,
      NULL,
      0.775408,
      0,
      5,
      4,
      0,
      NULL,
      0,
      5.817881,
      0.787340,
      0,
      7.264397,
      NULL,
      2.214213,
      NULL,
      0.037698,
      NULL,
      NULL,
      0,
      0,
      2.546219,
      5,
      1,
      3,
      4.065978,
      1.992272,
      5,
      3,
      0,
      1,
      1,
      NULL,
      5.886818,
      1.273988,
      7,
      NULL,
      3.159130,
      7,
      5,
      3,
      7.926093,
      8.379579,
      5.225289,
      0,
      0.635420,
      3,
      3,
      1,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.036803,
      0.920019,
      1.054388,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515393,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0,
      0.880037,
      3.842338,
      6,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.359558,
      4,
      3,
      4.732211,
      0,
      1,
      3.679820,
      NULL,
      NULL,
      NULL,
      0.095033,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.886072,
      1.835542,
      3,
      2,
      0,
      3,
      NULL,
      3,
      0.897371,
      0.461424,
      0,
      0,
      1.372906,
      NULL,
      NULL,
      0.301514,
      0.805736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.925366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


