set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '30',
      NULL,
      28.586555,
      NULL,
      20.760380,
      2,
      2,
      3,
      '334042',
      2.952236,
      ' 7-14-1990',
      12.670735,
      8,
      1,
      NULL,
      0.777397,
      0.111593,
      0.604288,
      1.436570,
      0.912893,
      0.538550,
      NULL,
      NULL,
      NULL,
      1,
      0.571162,
      0,
      1,
      0.902703,
      1.767177,
      8.647846,
      2.692399,
      0.635883,
      0,
      NULL,
      NULL,
      0.829422,
      4.633343,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.817194,
      NULL,
      NULL,
      0,
      1,
      1.777983,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416560,
      NULL,
      NULL,
      1.111298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.814540,
      NULL,
      1.791653,
      0.816896,
      NULL,
      1.507174,
      2,
      1,
      3.280741,
      0,
      3.417687,
      NULL,
      1.447111,
      6.032481,
      0,
      1,
      1.178998,
      0,
      NULL,
      NULL,
      0.389371,
      NULL,
      2,
      1,
      5,
      5,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.434425,
      1,
      1,
      1,
      4.644059,
      1.549084,
      2.545019,
      3,
      9.009980,
      10,
      2,
      0,
      4.623591,
      2.278087,
      1,
      NULL,
      NULL,
      2,
      0.750557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.692545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.759821,
      NULL,
      9.442692,
      0,
      0,
      0,
      NULL,
      1.863050,
      0,
      1.092325,
      2.487868,
      0,
      0.520915,
      1.178519,
      NULL,
      NULL,
      NULL,
      1.389940,
      3.211942,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.661323,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024751,
      1.104679,
      1.177553,
      1.759514,
      NULL,
      3,
      2.893111,
      0,
      2,
      1,
      NULL,
      1.755299,
      1,
      0.370076,
      1,
      1,
      1.981144,
      0.531462,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '34334',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.567960,
      '1430',
      '',
      '',
      0.916219,
      3,
      1.455653,
      NULL,
      3.624546,
      NULL,
      0,
      NULL,
      3.458904);
commit;
end;
/


