set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '23420423',
      37.395077,
      24.128726,
      '2303021',
      NULL,
      1,
      0.567974,
      NULL,
      '123114',
      4,
      ' 3-25-1995',
      46.637574,
      35.508781,
      NULL,
      NULL,
      2.656135,
      0.918335,
      1.043191,
      0.802816,
      0,
      NULL,
      0.727236,
      0.966402,
      NULL,
      0,
      3.392117,
      1.915611,
      1,
      1.180125,
      1,
      7.701533,
      0,
      NULL,
      1.603595,
      1,
      NULL,
      0.364484,
      9,
      1,
      NULL,
      NULL,
      2.477337,
      0.454781,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.403333,
      1.378277,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.667327,
      1.212799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.076678,
      1.993615,
      1,
      7,
      7,
      7.513304,
      0.659850,
      0.297147,
      0.377462,
      5.332196,
      1.646503,
      1.912081,
      5.612227,
      1,
      1,
      1.162911,
      0.350795,
      0,
      NULL,
      0,
      0,
      5.373732,
      2,
      0,
      9,
      5,
      0,
      0,
      NULL,
      1.911502,
      2,
      1,
      1,
      4,
      0,
      NULL,
      6.440366,
      NULL,
      7,
      6.752075,
      0.315583,
      4,
      NULL,
      0,
      0.680305,
      NULL,
      2,
      0,
      1,
      2,
      3.286008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.859454,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167437,
      NULL,
      NULL,
      NULL,
      1,
      5,
      4,
      NULL,
      0.478050,
      NULL,
      0.850303,
      NULL,
      NULL,
      NULL,
      1.025164,
      0,
      1.856097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566835,
      1.914399,
      0,
      0,
      1.149986,
      0.902600,
      2,
      2,
      NULL,
      1,
      0.264679,
      0.063565,
      0.139637,
      1,
      NULL,
      0.363701,
      1.660954,
      0.873726,
      0.714603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '40311',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      '220',
      '',
      0,
      3.174023,
      2,
      NULL,
      1.514470,
      2.895394,
      4.563344,
      3.279796,
      2);
commit;
end;
/


