set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '14334231',
      NULL,
      47.884093,
      '2322202',
      NULL,
      5,
      NULL,
      3,
      '024433',
      1.459278,
      ' 7-14-1999',
      NULL,
      10,
      1,
      NULL,
      0.614303,
      1.487231,
      0.878679,
      1,
      NULL,
      NULL,
      1.774575,
      3,
      0,
      1,
      1.122224,
      0.747406,
      NULL,
      1.722482,
      1,
      1.324538,
      0.504823,
      0,
      1,
      1,
      1,
      NULL,
      1.621448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644159,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016265,
      NULL,
      1.885901,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263429,
      1.461049,
      1,
      0.465500,
      NULL,
      1,
      1.854777,
      1,
      1.463965,
      1,
      0.278873,
      NULL,
      1.486103,
      0,
      1.730099,
      1,
      NULL,
      0,
      0.998075,
      NULL,
      0,
      2,
      1,
      0.141719,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.867330,
      NULL,
      NULL,
      1.938915,
      0.412361,
      0.606064,
      3.165329,
      1,
      9,
      2,
      1.031687,
      10.464627,
      6.180954,
      0,
      0,
      0.878346,
      0.531409,
      NULL,
      NULL,
      2.710171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313893,
      0,
      0,
      NULL,
      1.312411,
      1.438450,
      NULL,
      1.486040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.142577,
      2.645554,
      1,
      0,
      0,
      1.751872,
      NULL,
      NULL,
      NULL,
      0.224442,
      5.216576,
      1.675040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282709,
      1.633320,
      1,
      0.166512,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.724728,
      NULL,
      0,
      0.988355,
      NULL,
      1.131721,
      NULL,
      1.227668,
      0.933333,
      0.106887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '13100',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      4,
      1.113796,
      NULL,
      NULL,
      3.710869,
      2.504130,
      0.876288,
      3,
      0);
commit;
end;
/


