set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '43340132',
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      3,
      3,
      '340132',
      0.329135,
      ' 7- 3-1998',
      43.623981,
      63.364425,
      0,
      NULL,
      1,
      0.029379,
      1.821970,
      1.112430,
      0,
      0.919572,
      NULL,
      1,
      NULL,
      0.804943,
      0,
      0.871711,
      0.965018,
      0.492788,
      NULL,
      1,
      1.252306,
      0,
      NULL,
      0.758561,
      1.756941,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.953113,
      0.640410,
      0.820975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167302,
      1.962254,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873576,
      1.964398,
      0,
      1.836013,
      1.924116,
      1.680123,
      NULL,
      1.349491,
      1,
      0.407795,
      1.124641,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.998213,
      NULL,
      0.243348,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      2.759184,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.566258,
      0,
      NULL,
      1,
      0.085066,
      4.224017,
      2,
      0,
      NULL,
      1.881451,
      NULL,
      2,
      0.212295,
      1,
      1.976145,
      1.003129,
      NULL,
      NULL,
      8,
      1.911294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117956,
      NULL,
      1,
      0.147221,
      1,
      1.034131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4.767014,
      1.912271,
      1.207686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.049694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793642,
      NULL,
      NULL,
      0.555612,
      0.044713,
      2,
      NULL,
      3.457577,
      NULL,
      0.485916,
      0,
      1,
      1,
      NULL,
      0.036637,
      1,
      0,
      0.543020,
      1.759941,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.014088,
      '01031',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      2,
      2,
      0.643632,
      2,
      NULL,
      NULL,
      NULL,
      2.254768,
      3);
commit;
end;
/


