set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '34124120',
      16,
      38.445018,
      '3001102',
      NULL,
      2,
      0.864232,
      0,
      NULL,
      5,
      NULL,
      38.621359,
      11.844737,
      NULL,
      NULL,
      0.456933,
      0,
      0.701916,
      NULL,
      1,
      NULL,
      1.440498,
      0.530963,
      0.122391,
      0.118580,
      1,
      0,
      NULL,
      0,
      1.273518,
      0,
      0.566722,
      1.619785,
      1.089402,
      0.813825,
      0,
      0,
      1.491185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.243367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.440005,
      1.566297,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.852862,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634492,
      0,
      NULL,
      0,
      1.568134,
      0,
      1.067775,
      NULL,
      0.746176,
      0,
      NULL,
      0.369209,
      NULL,
      0.813610,
      0.808398,
      NULL,
      1,
      1,
      1,
      5,
      1.491259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.771141,
      3.343217,
      0.636673,
      0.950633,
      NULL,
      3,
      2,
      8,
      1,
      5.574030,
      3.163440,
      8,
      1,
      1.762068,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1.779779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.328433,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442378,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.057744,
      0,
      0.473232,
      1.987950,
      0.400212,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931996,
      1,
      NULL,
      1.696761,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698891,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.771117,
      1.527693,
      3,
      3.116158,
      1,
      3,
      0,
      3.835786,
      0.221025,
      1,
      1,
      NULL,
      0.440023,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.926665,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.673794,
      '',
      '',
      '',
      3.550453,
      1,
      2.158842,
      5,
      0,
      1,
      1,
      NULL,
      2.532390);
commit;
end;
/


