set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9734610';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2040',
      '44302201',
      0.322656,
      63.655727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.108822,
      ' 8- 7-2002',
      35,
      36.135321,
      0,
      NULL,
      1.216361,
      NULL,
      0,
      1.925714,
      1,
      0,
      3.726985,
      1.880964,
      0.829612,
      1.067971,
      1.146386,
      1,
      0.313503,
      NULL,
      0.955269,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.508837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.845156,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790491,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.965129,
      0.223572,
      1.748515,
      1.751972,
      NULL,
      1,
      1,
      0,
      0.810728,
      NULL,
      NULL,
      0,
      NULL,
      1.004281,
      0,
      0.023226,
      NULL,
      0,
      5,
      0.162409,
      0.657270,
      4.410186,
      0,
      5.576338,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202349,
      0.548488,
      3,
      1,
      0.154697,
      0.157474,
      7,
      5.432195,
      0,
      0,
      0.204707,
      6.958290,
      3.622737,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.722777,
      1.489568,
      NULL,
      1.841034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895556,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.693861,
      3.818850,
      1.333975,
      NULL,
      NULL,
      NULL,
      0.940475,
      1.183931,
      NULL,
      NULL,
      1,
      NULL,
      1.232270,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.199438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.329538,
      0,
      0,
      1.835159,
      NULL,
      3.541869,
      0.586664,
      1.664656,
      1.643434,
      1,
      1,
      NULL,
      1,
      0.951259,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '01042',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      3.209975,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911157,
      0);
commit;
end;
/


