set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '3230312',
      8,
      1,
      0.975376,
      3,
      NULL,
      2.515091,
      '10-16-1978',
      28.353823,
      NULL,
      NULL,
      NULL,
      2.531402,
      1.135797,
      1,
      0.829255,
      0,
      NULL,
      0.287951,
      0,
      NULL,
      0,
      0,
      0.758523,
      1.877710,
      0,
      1.193496,
      0,
      0.681282,
      NULL,
      NULL,
      NULL,
      1.479139,
      0,
      3.040993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.303159,
      3,
      NULL,
      0.286121,
      0,
      NULL,
      1,
      0.369794,
      0.110274,
      NULL,
      1.899657,
      1,
      0.027461,
      0,
      1,
      0,
      0,
      0.473692,
      0.003494,
      0,
      5,
      1,
      0,
      NULL,
      1.609595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.563914,
      NULL,
      0,
      1,
      0,
      6.754554,
      NULL,
      1,
      2.160507,
      1.578458,
      1.954745,
      0.348212,
      1,
      3.040161,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      7.628984,
      0,
      NULL,
      0.793145,
      0,
      8,
      NULL,
      NULL,
      NULL,
      3,
      5.874931,
      0,
      5.042998,
      NULL,
      1.411852,
      NULL,
      1.590498,
      4,
      NULL,
      0,
      NULL,
      0.659585,
      0.130994,
      0.479864,
      NULL,
      7,
      1.367566,
      1.825604,
      0,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.885730,
      2,
      1,
      1.859874,
      1.415390,
      1,
      3.701010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      2.567119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.741508,
      6.491876,
      2.265015,
      1.080622,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.666699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251677,
      3.349216,
      NULL,
      0.442749,
      1,
      1.885755,
      3,
      0,
      NULL,
      3,
      0.452349,
      0,
      NULL,
      NULL,
      1.361079,
      NULL,
      0,
      1,
      0.506981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '12123',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.028512,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


