set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      18.332327,
      0,
      0,
      NULL,
      '234234',
      0,
      ' 4-26-1986',
      41.409130,
      NULL,
      0.971155,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.842493,
      3,
      1,
      1,
      0,
      0.140904,
      2.141030,
      1.821818,
      NULL,
      1,
      1.573943,
      NULL,
      8.878176,
      2,
      NULL,
      1.181319,
      3.455240,
      3.333694,
      9,
      0,
      1.386034,
      NULL,
      1.677848,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.221862,
      0,
      1.586187,
      NULL,
      1,
      0.681682,
      1.156194,
      0,
      0.962586,
      0.800206,
      1.980219,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      1.215756,
      0.468680,
      1.363624,
      6,
      1,
      1,
      1.003907,
      0,
      NULL,
      NULL,
      0.647438,
      NULL,
      NULL,
      0,
      4,
      3,
      5.985116,
      2,
      NULL,
      NULL,
      0.793424,
      NULL,
      1.570272,
      1,
      1,
      1.919392,
      1,
      0,
      0,
      NULL,
      0.975071,
      0.952087,
      NULL,
      1.795529,
      1.839384,
      1.109811,
      0,
      1,
      1,
      1,
      0,
      4,
      3,
      0.465570,
      NULL,
      0,
      0.703230,
      0.814546,
      7,
      0,
      8.396912,
      3,
      0,
      0.848299,
      NULL,
      0.615751,
      7.328485,
      6.372802,
      0.511243,
      18.785989,
      0.423545,
      3.507238,
      1,
      1,
      2,
      0,
      NULL,
      3,
      3.012889,
      1.667665,
      0.590598,
      2.332445,
      1.496322,
      2,
      NULL,
      5,
      3.599803,
      4,
      4.736026,
      0.108803,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.417700,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411851,
      1.415167,
      1.307666,
      0.715666,
      1.528431,
      1,
      NULL,
      NULL,
      1.257146,
      2.382967,
      1.223029,
      0,
      NULL,
      1,
      0.259600,
      1,
      NULL,
      NULL,
      NULL,
      0.615258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '21024',
      '',
      '',
      0,
      '',
      '',
      '',
      1.472958,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


