set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '3211241',
      44,
      0,
      2.641615,
      NULL,
      '013301',
      2,
      ' 0-16-1990',
      16.664284,
      NULL,
      0.128708,
      NULL,
      0,
      1.579156,
      0,
      1,
      1.549593,
      1.952486,
      1.831820,
      0.951237,
      1.211246,
      1,
      6,
      0.475263,
      0,
      0.939549,
      0,
      3,
      1,
      1,
      1.525424,
      1,
      0.717674,
      3.486078,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.799931,
      1,
      1,
      0,
      1.334757,
      NULL,
      0,
      0,
      NULL,
      0.873467,
      1.188061,
      0,
      1,
      1,
      0,
      0.500220,
      0,
      1.960902,
      0.464906,
      1,
      1.650814,
      0.701790,
      4,
      1,
      0,
      NULL,
      0.707613,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      3.615639,
      1.990601,
      3,
      0,
      0.069391,
      0.369240,
      1,
      1.198432,
      3.969789,
      0,
      1.066980,
      4,
      0,
      0,
      0,
      0.428049,
      1,
      NULL,
      1,
      6.286276,
      0.200184,
      0.661120,
      1.397270,
      0.348310,
      2.290582,
      0,
      0,
      NULL,
      4,
      0.368212,
      5.919889,
      1.068104,
      3.847978,
      NULL,
      0,
      8,
      3,
      5,
      6.403643,
      NULL,
      NULL,
      0.915567,
      6,
      0.168674,
      6,
      1.800604,
      3.519941,
      0.857532,
      NULL,
      NULL,
      0.462362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.111005,
      1,
      NULL,
      0.034821,
      0,
      1.324110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.904759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150590,
      0.421250,
      NULL,
      1.929492,
      1914.814213,
      8.516009,
      0,
      1.877317,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      0.714329,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.791759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.011068,
      1,
      3.711370,
      1,
      2,
      3.639814,
      1,
      2.430664,
      1.377268,
      1,
      0,
      1,
      1.368543,
      NULL,
      0,
      NULL,
      1.203974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00441',
      '',
      '',
      1,
      '',
      '',
      '',
      0.077405,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


