set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '0320003',
      51,
      5,
      2,
      0,
      '234031',
      NULL,
      ' 3- 2-1975',
      14.578402,
      NULL,
      1,
      NULL,
      5.539380,
      0.645212,
      0,
      NULL,
      2,
      0,
      1.597890,
      1.140418,
      1.134464,
      1.257243,
      4.492839,
      0.759572,
      4,
      1.791136,
      1.645715,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      4,
      4,
      0,
      2,
      1.238513,
      1.408046,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.742179,
      2.747691,
      1,
      0.624394,
      3.714906,
      0,
      NULL,
      0.086908,
      1.033881,
      0,
      0.679158,
      0.753830,
      1.778294,
      0.654381,
      0,
      0.402577,
      0,
      7.025044,
      1.907252,
      1.492075,
      2,
      1,
      2,
      1.479782,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.624017,
      5,
      4,
      5.952985,
      1.643650,
      NULL,
      1.953837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269188,
      4,
      NULL,
      1,
      0,
      NULL,
      1.000548,
      NULL,
      0.923685,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.127725,
      0,
      0.071572,
      0,
      2.197991,
      4.920793,
      6.967946,
      1.404942,
      6.861341,
      NULL,
      1.366207,
      3.930844,
      6.486680,
      8,
      6.459191,
      NULL,
      8.926485,
      11,
      NULL,
      1,
      8.670293,
      0.595767,
      3,
      0,
      NULL,
      NULL,
      6,
      4.792750,
      NULL,
      2.436773,
      0.195335,
      1,
      4,
      2.038834,
      2,
      1,
      NULL,
      1.727146,
      7.540353,
      3.122226,
      1,
      5,
      1.952846,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.105313,
      5,
      0.304306,
      1,
      2.921860,
      NULL,
      1,
      0.256843,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.974211,
      1.569147,
      0.017601,
      1,
      2.413571,
      2,
      0.854115,
      NULL,
      NULL,
      NULL,
      1.429129,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913239,
      NULL,
      NULL,
      0.425418,
      0,
      2,
      2.110648,
      1.955917,
      1,
      1.830882,
      1,
      0,
      1,
      1,
      1.156878,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '44144',
      NULL,
      NULL,
      0.703882,
      '',
      '',
      '',
      1.940460,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


