set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '3002441',
      NULL,
      0,
      NULL,
      NULL,
      '210132',
      1,
      ' 4- 0-1984',
      39.340295,
      NULL,
      0.025046,
      NULL,
      0.380905,
      NULL,
      1,
      0.631894,
      1.167768,
      NULL,
      NULL,
      NULL,
      0,
      0.540483,
      9.357372,
      1,
      1.287719,
      1.060194,
      1,
      0,
      5,
      1,
      NULL,
      8.149357,
      NULL,
      8.408238,
      7,
      1,
      NULL,
      0.480602,
      1.332069,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.850450,
      NULL,
      1.871861,
      2,
      1,
      0.368310,
      3.401933,
      3,
      NULL,
      0.484656,
      0.884746,
      NULL,
      0,
      NULL,
      1.359988,
      0,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      0,
      3,
      1,
      0.832081,
      1,
      NULL,
      NULL,
      0.065043,
      NULL,
      NULL,
      0,
      2.982950,
      0.954585,
      1.048217,
      NULL,
      NULL,
      1.738912,
      0,
      3,
      0,
      NULL,
      7.312835,
      0.044905,
      3,
      NULL,
      0.134002,
      1,
      0.908008,
      0,
      NULL,
      NULL,
      7.518753,
      3,
      NULL,
      5.159698,
      3,
      3,
      0,
      NULL,
      0,
      0.016762,
      6,
      2,
      1,
      NULL,
      NULL,
      1,
      3.312973,
      7,
      NULL,
      1.960794,
      3,
      NULL,
      2.506809,
      7.695936,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5,
      6,
      NULL,
      1,
      1,
      0,
      3.032687,
      2.944377,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      0.142478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      2,
      1.104487,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185290,
      NULL,
      2,
      0,
      NULL,
      1.051537,
      1.997436,
      2,
      1.626614,
      NULL,
      0.291937,
      NULL,
      NULL,
      0.214544,
      0.997481,
      0.334660,
      1.073866,
      1.995363,
      0,
      1.917628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.346035,
      '01312',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


