set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.658742,
      4,
      0,
      3,
      '204333',
      2,
      ' 5- 7-1977',
      13.204325,
      NULL,
      NULL,
      NULL,
      0.468786,
      1.504523,
      1,
      NULL,
      0.126987,
      1.119019,
      NULL,
      1,
      1,
      0.680733,
      2,
      0.548697,
      0,
      NULL,
      0.160671,
      3.630097,
      4.301206,
      0.513241,
      0.047269,
      1.903484,
      5,
      6.687636,
      7,
      1,
      NULL,
      0,
      0.301161,
      0,
      NULL,
      NULL,
      0.087457,
      NULL,
      NULL,
      9,
      NULL,
      2.552476,
      2.337626,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.103519,
      0,
      1,
      1.254051,
      NULL,
      NULL,
      1.339746,
      1.946302,
      NULL,
      NULL,
      1,
      1.421290,
      7.907907,
      1,
      1,
      2,
      0.682936,
      NULL,
      NULL,
      0.127568,
      NULL,
      NULL,
      0.436626,
      NULL,
      4.527187,
      NULL,
      1,
      0.757374,
      0,
      1,
      1.339445,
      NULL,
      2.621369,
      0,
      1,
      0.251374,
      NULL,
      1,
      NULL,
      0,
      1.706940,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      NULL,
      2,
      NULL,
      3.506490,
      NULL,
      4,
      4.193341,
      2,
      NULL,
      1.240780,
      4.885060,
      1.942783,
      0,
      4.935066,
      NULL,
      6,
      5,
      0,
      1.190936,
      3.152328,
      NULL,
      2.832486,
      5,
      0,
      0,
      1.569561,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687116,
      1,
      0,
      1,
      NULL,
      0.481405,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345730,
      2.093188,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.489545,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.594952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.298392,
      1,
      NULL,
      1.031991,
      NULL,
      2,
      1.432004,
      0.867792,
      3.989236,
      NULL,
      1,
      0,
      1,
      1.225353,
      0,
      NULL,
      0,
      1.927410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '02142',
      '',
      '',
      0,
      '',
      '',
      '',
      0.411864,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


