set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '3120313',
      78,
      NULL,
      2,
      0,
      '224332',
      0.434957,
      ' 4- 5-1989',
      NULL,
      NULL,
      1.017520,
      NULL,
      3,
      0.118395,
      0.985881,
      1.155918,
      0.022588,
      2.813142,
      1,
      0,
      1,
      0.328883,
      NULL,
      0.158833,
      1,
      1.685892,
      0.404623,
      7.844995,
      6.823882,
      0,
      0.858965,
      7.634594,
      2.876095,
      7.778658,
      NULL,
      1,
      NULL,
      1,
      1,
      0.853965,
      NULL,
      NULL,
      1.546215,
      NULL,
      NULL,
      7,
      3.290428,
      2.915404,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.153820,
      1,
      NULL,
      1.559745,
      3.944604,
      3,
      NULL,
      0,
      0.171571,
      1,
      3,
      1,
      1.071537,
      4,
      0,
      1,
      NULL,
      1.651245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.846224,
      6.717173,
      2.592053,
      NULL,
      0.092924,
      1.167503,
      1.167231,
      0.083561,
      NULL,
      0,
      5,
      0,
      0.982553,
      0.067051,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1.568746,
      7.989592,
      0,
      0.492826,
      0,
      5,
      1.433347,
      NULL,
      NULL,
      3.249100,
      7,
      1.525966,
      8.383087,
      4.491942,
      NULL,
      8.796054,
      6,
      7,
      4.508387,
      7,
      NULL,
      7,
      7.754616,
      1,
      1.603091,
      1.891353,
      1.024169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.985734,
      NULL,
      0,
      0.998426,
      NULL,
      0.899593,
      1.298945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.980584,
      1,
      1.331327,
      NULL,
      NULL,
      0,
      7.611546,
      0,
      NULL,
      NULL,
      1.321869,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131329,
      1,
      2,
      0.799816,
      2,
      NULL,
      NULL,
      3.539243,
      0.355327,
      0,
      0.920011,
      0.557437,
      0,
      1.335007,
      0.604902,
      0,
      0.472969,
      NULL,
      NULL,
      1.057990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '10141',
      '',
      '',
      0.699227,
      NULL,
      '',
      '',
      0.009598,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


