set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '2010213',
      104,
      2,
      2.417326,
      NULL,
      NULL,
      0.672562,
      ' 0- 4-1981',
      38.927776,
      NULL,
      0.916398,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1.301057,
      1.175243,
      1.651423,
      1.277895,
      2.048355,
      0.984494,
      0.193831,
      1.118929,
      1.462175,
      3,
      4,
      1,
      3.240704,
      1.378487,
      1.234619,
      3.021378,
      4,
      NULL,
      5,
      NULL,
      1.174445,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.061697,
      1.444961,
      NULL,
      0.955348,
      0,
      0,
      1,
      1.923693,
      0.542043,
      1.874584,
      1.483398,
      0.296326,
      0,
      1,
      0.263501,
      1,
      2,
      1,
      1.074064,
      7.279189,
      0,
      0,
      NULL,
      0.438558,
      NULL,
      NULL,
      1.117463,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.688452,
      1,
      1,
      NULL,
      0,
      0.558252,
      0,
      NULL,
      1,
      0,
      0.458177,
      1.009061,
      0,
      0,
      NULL,
      1.104215,
      NULL,
      1.110432,
      1,
      NULL,
      0.967982,
      1,
      NULL,
      5.657074,
      1,
      2,
      0.926702,
      0.359070,
      1.853931,
      0,
      NULL,
      NULL,
      1.759574,
      NULL,
      5.998816,
      2.187403,
      NULL,
      0.178811,
      2.524516,
      NULL,
      7,
      NULL,
      1,
      17.000458,
      0.857864,
      1,
      1,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.092185,
      0,
      1,
      1,
      1.652641,
      0.355795,
      0.518559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3.813583,
      0,
      0.686421,
      1.196797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.185156,
      NULL,
      NULL,
      NULL,
      1.734566,
      3.011456,
      5.882960,
      5,
      1.121296,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.078445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020232,
      0.249195,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0.356724,
      3,
      2,
      NULL,
      1.399240,
      0.768228,
      1.070970,
      1,
      0,
      0.533071,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '30132',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


