set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '4200200',
      89.104821,
      0,
      1.126466,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      3.196187,
      0.255435,
      0.797440,
      1,
      1.559945,
      3.501309,
      3,
      1.024433,
      1,
      0,
      0,
      1,
      1.011876,
      4.504179,
      2,
      0.867938,
      7.043810,
      0,
      1.331437,
      3,
      0,
      1,
      0.286450,
      0,
      2,
      1,
      0.137409,
      0.586982,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1.215676,
      NULL,
      0,
      NULL,
      0,
      1.375305,
      0.894715,
      1.835273,
      0,
      0.530992,
      NULL,
      1.408596,
      1.968325,
      1,
      NULL,
      0,
      1.451651,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.514692,
      NULL,
      NULL,
      0.779666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      0.576634,
      0,
      1.385098,
      3,
      0,
      1.099972,
      NULL,
      1,
      0,
      0.698303,
      1,
      0,
      NULL,
      1.319575,
      2.213345,
      0,
      NULL,
      2.023980,
      0.115122,
      4,
      NULL,
      2,
      5.735121,
      2.525434,
      5.696130,
      NULL,
      NULL,
      0.453136,
      4,
      1,
      0,
      9,
      0.698377,
      5,
      9,
      5.441142,
      9,
      8.699181,
      NULL,
      4.203897,
      4.010076,
      1.426884,
      1.122580,
      0,
      NULL,
      1.357020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.135764,
      1.563298,
      0,
      0,
      1.310594,
      1,
      1,
      0.808723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      1.577046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.648701,
      3,
      NULL,
      0.344968,
      NULL,
      1.453385,
      2.584624,
      NULL,
      2.682814,
      NULL,
      NULL,
      1,
      1,
      1.305928,
      NULL,
      NULL,
      0.228632,
      0,
      0.594885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '30410',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.795768,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


