set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      '4420244',
      90,
      3,
      3.740151,
      NULL,
      '321441',
      3,
      NULL,
      26.119567,
      NULL,
      0.698509,
      NULL,
      NULL,
      0.679479,
      0.806473,
      NULL,
      0.614776,
      2.999708,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1.254528,
      0,
      0,
      NULL,
      0.564399,
      1,
      1.409339,
      0.429588,
      1.238881,
      0,
      6.997346,
      0,
      0,
      3,
      0.196184,
      0.209171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      3,
      1.784500,
      NULL,
      0.874374,
      1,
      NULL,
      1,
      0.104084,
      0,
      NULL,
      1,
      1.128851,
      1.132910,
      NULL,
      0,
      1.473041,
      0,
      0,
      0.185240,
      0.157917,
      1.036452,
      3.265013,
      0,
      1,
      3.924243,
      0.070614,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      1.413307,
      0.278575,
      0.948659,
      NULL,
      0,
      1,
      0,
      4,
      1.851955,
      NULL,
      3,
      0.253757,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.736915,
      0,
      1,
      5.426146,
      1.720352,
      5,
      1,
      4.802540,
      0,
      NULL,
      0.975287,
      3,
      1.753861,
      0,
      0.698944,
      1,
      3.339639,
      NULL,
      3.961029,
      6,
      2.208937,
      3,
      NULL,
      13,
      5,
      2,
      0.670250,
      0,
      1.665801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.557705,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.638004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433261,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.378785,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.061892,
      1,
      0.698834,
      NULL,
      0,
      0.422798,
      NULL,
      NULL,
      NULL,
      1.569771,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.374254,
      2,
      1.715587,
      0,
      3,
      0,
      1,
      NULL,
      1,
      0.044922,
      0.684491,
      0.080260,
      0,
      0.736607,
      1.545076,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490661,
      '20100',
      '',
      '',
      0.870580,
      NULL,
      '',
      '',
      0.308218,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


