set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '1021220',
      144.648763,
      NULL,
      0.929006,
      1,
      '422321',
      1.083243,
      ' 1-10-1981',
      25,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.837884,
      1,
      0.280118,
      0,
      0,
      0,
      1,
      8.673391,
      0.204099,
      1.809504,
      NULL,
      1,
      0.040047,
      0,
      0,
      NULL,
      1,
      0.864161,
      0.620527,
      1,
      0,
      NULL,
      1,
      0.533149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.021587,
      NULL,
      NULL,
      0.400900,
      1,
      0.012175,
      0,
      1.907741,
      1.199532,
      0,
      0.961376,
      1.203911,
      1.198869,
      1.934928,
      1.772445,
      NULL,
      1.284362,
      0.589184,
      0.713630,
      1.666945,
      1.241767,
      0,
      7.236848,
      0,
      2,
      1.281002,
      NULL,
      NULL,
      NULL,
      1.562709,
      NULL,
      NULL,
      1,
      4.973924,
      NULL,
      1.417764,
      0.961890,
      0,
      0.962497,
      NULL,
      NULL,
      1,
      4.167468,
      0,
      0,
      4,
      NULL,
      1,
      0.903690,
      NULL,
      1.206137,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.717149,
      NULL,
      0.349012,
      4.568398,
      1.683288,
      0,
      0.969407,
      1,
      1,
      3.897909,
      NULL,
      1,
      1.837084,
      4,
      4,
      1,
      1.845318,
      4.669718,
      1,
      NULL,
      2.088191,
      17.107874,
      2,
      3.267022,
      1.081233,
      0,
      6.488040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.056724,
      0,
      1.506031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510235,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482949,
      0.931338,
      NULL,
      1.686807,
      1,
      NULL,
      1.654835,
      NULL,
      NULL,
      NULL,
      1.299704,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014486,
      2,
      NULL,
      1.009528,
      0,
      3.797330,
      2.280913,
      3,
      1,
      NULL,
      NULL,
      1.507217,
      1,
      0,
      0,
      1.050823,
      NULL,
      0,
      0.139959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.750563,
      '32210',
      '',
      '',
      0.501591,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


