set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      16.949353,
      13.126954,
      '0011303',
      NULL,
      3,
      1.370436,
      0,
      '431011',
      4.623204,
      '11-11-1977',
      31.244091,
      40,
      1.608195,
      NULL,
      1,
      1.591844,
      0.612101,
      1.099720,
      NULL,
      NULL,
      NULL,
      0,
      0.098865,
      1,
      3.691785,
      1.388612,
      0,
      NULL,
      2.535666,
      1,
      NULL,
      1,
      0,
      0.851093,
      0,
      0,
      7,
      0,
      1.313478,
      0,
      0.213753,
      0.261807,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.478863,
      1,
      NULL,
      3.594740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.237539,
      NULL,
      2,
      0,
      1.986534,
      NULL,
      NULL,
      1.504383,
      NULL,
      NULL,
      1.597281,
      3,
      5,
      0.980308,
      0,
      2,
      3,
      0,
      0,
      0.999384,
      NULL,
      0,
      1.632918,
      NULL,
      1.592743,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1.462191,
      0.098937,
      1.037863,
      0,
      1.841211,
      0.093692,
      3.602673,
      1,
      0,
      0,
      5.220677,
      0.902995,
      NULL,
      5,
      0,
      2,
      4.678718,
      5.418803,
      1.273023,
      7.074319,
      5,
      3.761908,
      4,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      9.727875,
      1.370086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558932,
      1.516963,
      0,
      0,
      0.485467,
      0,
      0.549901,
      0.142278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360674,
      0.952591,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.600460,
      1.459237,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.802141,
      0.709357,
      NULL,
      3.243388,
      1.476470,
      1.006527,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.530883,
      1.109345,
      0,
      1.028073,
      0,
      1.513146,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '30000',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


