set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '02',
      37.984358,
      10.828917,
      '0400311',
      123,
      4,
      0.499818,
      0,
      '340212',
      3.326793,
      ' 5-29-1997',
      NULL,
      32.682559,
      1.412708,
      NULL,
      NULL,
      NULL,
      0.081128,
      NULL,
      0,
      0,
      0.167188,
      0,
      1.673014,
      NULL,
      0.044188,
      1,
      1.728196,
      3.576993,
      NULL,
      1.330808,
      3,
      1,
      1.151181,
      0.731570,
      1.313144,
      0,
      4,
      0,
      4.225096,
      NULL,
      1.927750,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      0,
      3.485933,
      1.789422,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.045752,
      0,
      0,
      5,
      1,
      0,
      NULL,
      1.198167,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.092254,
      NULL,
      3.725416,
      1.386365,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.317351,
      0,
      1.670508,
      NULL,
      NULL,
      0.453681,
      0.730197,
      0,
      NULL,
      NULL,
      0,
      0.576832,
      1.661147,
      0.081727,
      NULL,
      1,
      5,
      1.074786,
      2,
      0.976792,
      NULL,
      1.474969,
      NULL,
      NULL,
      0.513290,
      4,
      0.394532,
      5.500368,
      3,
      2.108290,
      NULL,
      NULL,
      0,
      NULL,
      1.990069,
      3,
      NULL,
      5.128019,
      2,
      0,
      1.629352,
      5,
      0.372936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989129,
      1.897305,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837151,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.301842,
      0.134772,
      NULL,
      NULL,
      NULL,
      NULL,
      3.429865,
      NULL,
      1,
      1.297811,
      NULL,
      1,
      1.497889,
      NULL,
      NULL,
      NULL,
      0.344499,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.568890,
      2,
      2.857089,
      NULL,
      0.926260,
      0.265311,
      2,
      1.399948,
      3,
      1,
      1.408226,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.828736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '14302',
      '',
      '',
      0.282320,
      '',
      '',
      '',
      0.273116,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


