set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '43',
      6.295715,
      NULL,
      '3023323',
      NULL,
      NULL,
      1,
      3,
      '104144',
      0,
      ' 1-28-1987',
      32.258520,
      105,
      0,
      NULL,
      NULL,
      1.161440,
      0,
      0.990913,
      0.518612,
      1.051564,
      NULL,
      NULL,
      0.881583,
      NULL,
      1,
      0,
      1.390046,
      1,
      2,
      0,
      6,
      NULL,
      0,
      NULL,
      1,
      NULL,
      6.077193,
      1,
      1.137602,
      NULL,
      0,
      1.905532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.918825,
      0.814097,
      0,
      0.875879,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.875040,
      2,
      3,
      0,
      2.817897,
      1,
      NULL,
      NULL,
      1.763105,
      NULL,
      2,
      0,
      1,
      4,
      0.110015,
      0.134932,
      1.630879,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.303109,
      0,
      NULL,
      3,
      1.512836,
      4.921946,
      1.824196,
      0,
      1.022851,
      3.283935,
      0.070442,
      2.614384,
      NULL,
      NULL,
      2.916331,
      0.579064,
      2,
      0.492968,
      NULL,
      0.246757,
      NULL,
      9.509009,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.233830,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173641,
      NULL,
      1,
      NULL,
      0,
      0.234061,
      1,
      1.092880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379031,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.411730,
      0.387591,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.836682,
      2,
      NULL,
      2.161844,
      NULL,
      1.948829,
      NULL,
      0,
      1,
      NULL,
      1.015552,
      0,
      0.438438,
      0,
      1,
      0.093747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '34432',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.640529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


