set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '24',
      34.235003,
      7.829428,
      '3121233',
      98,
      2,
      NULL,
      3,
      '414024',
      0,
      ' 1-27-2000',
      5.163809,
      16,
      NULL,
      NULL,
      2.860015,
      1,
      1.078474,
      1,
      1.188476,
      1,
      2.268632,
      0,
      0,
      1.493474,
      6,
      1,
      1.847390,
      6,
      3,
      3,
      8.247206,
      1.355648,
      NULL,
      0.303274,
      1,
      0,
      7.579910,
      0,
      4.672412,
      2,
      0.290122,
      1.723919,
      NULL,
      NULL,
      1.522904,
      NULL,
      NULL,
      8,
      0,
      3,
      1.187434,
      NULL,
      NULL,
      NULL,
      1,
      0.933283,
      0.487922,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.556665,
      1.808392,
      6.310321,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.127446,
      NULL,
      NULL,
      NULL,
      5,
      2.287543,
      NULL,
      3.876300,
      NULL,
      0.007020,
      1,
      0.222887,
      0,
      0,
      1,
      2,
      2,
      1,
      1,
      0.699794,
      1.185493,
      1.072777,
      NULL,
      0.614630,
      1,
      1.016270,
      1.730195,
      2,
      0,
      NULL,
      1,
      5,
      1.994552,
      2,
      NULL,
      0.172869,
      NULL,
      3,
      0,
      NULL,
      4,
      4.901072,
      0.662538,
      5.571353,
      NULL,
      NULL,
      3,
      7.156266,
      1.760175,
      NULL,
      0.189334,
      1,
      0.235129,
      1.373143,
      5,
      0.380624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884124,
      1.048738,
      0,
      NULL,
      1.020050,
      1,
      0.567389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.435731,
      0,
      NULL,
      NULL,
      0,
      0,
      1.546502,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757925,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697360,
      2,
      3,
      0.628688,
      0,
      3.660096,
      1.180815,
      0,
      1.836514,
      1,
      0.191100,
      0,
      1,
      0,
      1.866272,
      1,
      1,
      1.612723,
      1,
      0.968094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.948390,
      '02443',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.359206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


