set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32',
      24,
      25.341624,
      '0423444',
      NULL,
      2,
      NULL,
      1,
      '114431',
      2,
      ' 9-25-1981',
      22.711406,
      NULL,
      0.920592,
      NULL,
      NULL,
      1.508570,
      0.144460,
      NULL,
      NULL,
      1.239929,
      0,
      1,
      NULL,
      NULL,
      0.086112,
      1.935040,
      0,
      7,
      NULL,
      1.318151,
      0.521018,
      NULL,
      1,
      1,
      2,
      3,
      3.963829,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1.048566,
      NULL,
      NULL,
      11.998686,
      NULL,
      1.316924,
      3.217648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.902073,
      1,
      1,
      6,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.142450,
      NULL,
      NULL,
      0.196993,
      3.853506,
      NULL,
      2,
      0,
      0.246924,
      1,
      0.712169,
      1.073633,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      1.265499,
      1,
      1.289398,
      0.628157,
      NULL,
      0,
      NULL,
      0.935215,
      1,
      NULL,
      1,
      NULL,
      1.552260,
      5.589973,
      3.104859,
      NULL,
      0,
      4,
      NULL,
      5.676878,
      3,
      1.146674,
      2.868422,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.444282,
      0.389241,
      1,
      0.203866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.660652,
      0.563614,
      0.219317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.942871,
      NULL,
      NULL,
      NULL,
      NULL,
      0.270675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.589639,
      1.423837,
      1.528969,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.518403,
      0,
      0,
      1,
      3,
      1.615456,
      2,
      0.145197,
      1,
      NULL,
      0.751610,
      0.458128,
      0.171222,
      1.005135,
      0.186314,
      0.627601,
      0,
      1,
      1.046438,
      1.927122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      1.890873,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      5.732883,
      3,
      1,
      4.971343,
      0,
      3.361373,
      3.538589,
      3.819228,
      2.822400);
commit;
end;
/


