set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      '32041244',
      39,
      35,
      '1040343',
      131.888540,
      0,
      1.969295,
      NULL,
      '310300',
      0.252180,
      ' 0-11-1992',
      NULL,
      NULL,
      1.887207,
      NULL,
      NULL,
      1.584304,
      1,
      0,
      0.042476,
      NULL,
      0,
      0.885151,
      1,
      1.867082,
      3.398005,
      0,
      1.995090,
      1,
      0,
      1,
      5,
      0.199253,
      2.620186,
      3,
      0.701894,
      0.603260,
      7,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.156991,
      NULL,
      NULL,
      2,
      NULL,
      3.997914,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167567,
      1.999336,
      1.254904,
      7.687101,
      NULL,
      1,
      2.775537,
      0.378038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044111,
      4.391466,
      4,
      0.309714,
      0,
      5,
      3,
      1.666848,
      0.985153,
      1,
      0,
      1.405085,
      1.654475,
      1,
      0.525783,
      0.495785,
      1.956873,
      NULL,
      1.228712,
      NULL,
      0.173918,
      NULL,
      0,
      1,
      1.317034,
      NULL,
      3.905567,
      0.737174,
      4,
      1,
      6,
      3.212248,
      4,
      NULL,
      NULL,
      2,
      1,
      NULL,
      7,
      6.015984,
      5.824977,
      0.173271,
      0,
      NULL,
      0.591981,
      5,
      NULL,
      1.481755,
      0.152144,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.551420,
      0,
      1,
      NULL,
      NULL,
      0.783331,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0.241184,
      NULL,
      NULL,
      NULL,
      0.133975,
      0,
      1.971847,
      NULL,
      1.669718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.541349,
      0,
      3.867692,
      1,
      0.445795,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0.499269,
      1,
      1.343516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.760855,
      '24422',
      '',
      '',
      1.103916,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.906705,
      0.398226,
      2,
      1.887840,
      1.460761,
      NULL,
      NULL,
      3.734442,
      NULL);
commit;
end;
/


