set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '234',
      NULL,
      NULL,
      NULL,
      '4324022',
      22,
      6,
      0.951142,
      1,
      '443233',
      5.025813,
      ' 1-26-1976',
      NULL,
      16.089399,
      NULL,
      NULL,
      0.786766,
      1,
      1.856253,
      1,
      NULL,
      3,
      1.511339,
      0,
      0.371559,
      NULL,
      7,
      1,
      0.672198,
      NULL,
      NULL,
      NULL,
      6.441660,
      0,
      1,
      1.179240,
      0,
      3.958884,
      NULL,
      1,
      5.477528,
      3.458736,
      1.960060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      1.133246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.920122,
      2.296152,
      0,
      1,
      2,
      1.260599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097818,
      0,
      NULL,
      NULL,
      2,
      5,
      1,
      0,
      0,
      0,
      0.865263,
      3,
      0.112103,
      2,
      1.250803,
      0.386129,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0.513056,
      1,
      1,
      1.027326,
      2,
      NULL,
      0,
      1.429065,
      1.110588,
      2,
      5.703899,
      NULL,
      3.625593,
      1,
      0,
      0.891102,
      7,
      7.167794,
      1,
      1.688935,
      0,
      6,
      NULL,
      4,
      NULL,
      5,
      2.007309,
      0,
      NULL,
      3.780732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.148295,
      0.035201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772828,
      3.525393,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.199145,
      0,
      2,
      0,
      2,
      1.854203,
      NULL,
      NULL,
      NULL,
      1.111108,
      0.906943,
      1.672364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408182,
      2.391935,
      0,
      1,
      NULL,
      1,
      1.417590,
      2,
      0,
      1.858869,
      0,
      1,
      1,
      1.401183,
      1.559861,
      0.614571,
      1.495054,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.494858,
      '22111',
      '',
      '',
      1.262070,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1.528306,
      NULL,
      3,
      1.097305,
      2.367727,
      1.939003,
      1.737101,
      2.773582,
      1);
commit;
end;
/


