set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '223',
      '40303113',
      NULL,
      3.717617,
      '1320014',
      132,
      0,
      3.984899,
      3,
      '404113',
      0.493419,
      ' 5- 9-1995',
      NULL,
      48,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.566107,
      0.493031,
      NULL,
      0,
      1.800119,
      6,
      0,
      NULL,
      0,
      2,
      0,
      3.109914,
      0,
      NULL,
      3.909194,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.805741,
      0.122314,
      1,
      0.999410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841161,
      1.179637,
      1.443199,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.320433,
      3.294910,
      1.538521,
      NULL,
      NULL,
      NULL,
      1,
      0.978428,
      NULL,
      1,
      0,
      1,
      5,
      1,
      0,
      0.028317,
      1.782039,
      1.693725,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.152387,
      1.513923,
      0,
      1,
      4,
      1.626666,
      NULL,
      3.248613,
      2,
      1.440733,
      NULL,
      3.664995,
      0,
      5,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.562667,
      3,
      NULL,
      NULL,
      1.341852,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.096567,
      1,
      0,
      0.543050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.840444,
      0,
      0.603137,
      1,
      1.485227,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.266722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047624,
      0,
      3,
      NULL,
      NULL,
      1,
      1.848044,
      0,
      0,
      NULL,
      1.248736,
      0,
      0.702010,
      NULL,
      1,
      1,
      0,
      1.907723,
      0,
      0.118934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '41404',
      '',
      '',
      1.130660,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      0,
      2,
      1.578241,
      2.438891,
      NULL,
      2,
      1.794417,
      3.126799,
      0.892958);
commit;
end;
/


