set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '32411343',
      13,
      43,
      NULL,
      211.735701,
      0,
      1.665077,
      0,
      '221441',
      3.408209,
      NULL,
      1,
      62.962961,
      1,
      NULL,
      3.058409,
      1.366086,
      NULL,
      1,
      1,
      3,
      0,
      1,
      1.775660,
      NULL,
      NULL,
      0.307180,
      1,
      6.114282,
      7.296669,
      1,
      6,
      NULL,
      0,
      1.012397,
      2,
      NULL,
      6,
      0,
      4.853665,
      0,
      4.121675,
      0.498530,
      NULL,
      NULL,
      1.437625,
      NULL,
      NULL,
      2.977555,
      3.102767,
      0,
      0.661357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.034091,
      1.513905,
      NULL,
      0,
      2,
      1.713889,
      NULL,
      NULL,
      NULL,
      0.231992,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.959339,
      NULL,
      NULL,
      0.614886,
      NULL,
      1,
      1.586502,
      1,
      NULL,
      5,
      1,
      0.148507,
      0.440534,
      0,
      0,
      NULL,
      0,
      1.186510,
      1.348194,
      0,
      4,
      NULL,
      6.004267,
      0,
      2,
      NULL,
      NULL,
      1,
      4,
      2.981002,
      NULL,
      3,
      1,
      4.591485,
      4,
      5.853671,
      0,
      5,
      5,
      11,
      2.929497,
      1.112072,
      NULL,
      4.619859,
      NULL,
      1.710543,
      NULL,
      0,
      1.204611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.904959,
      0,
      0,
      0.619809,
      1,
      0.970957,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.775484,
      0.626171,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.960091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814090,
      3,
      2.412959,
      NULL,
      NULL,
      3,
      3,
      3.692435,
      1,
      1,
      1.403888,
      0,
      1,
      0,
      0.066704,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01334',
      '',
      NULL,
      1.461532,
      '',
      '',
      NULL,
      1.651840,
      '',
      '',
      '',
      3,
      2,
      2.906136,
      1,
      3.062361,
      NULL,
      2,
      1.379737,
      0);
commit;
end;
/


