set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '420',
      '11440112',
      39.834481,
      63,
      '2023321',
      144.624878,
      6,
      3.848635,
      2,
      '232213',
      NULL,
      NULL,
      1,
      25.385029,
      0.308575,
      NULL,
      3.560598,
      1.062224,
      1.378823,
      0,
      NULL,
      2,
      0.843644,
      0.630595,
      1,
      1,
      1.646155,
      NULL,
      0,
      NULL,
      5,
      NULL,
      6.213529,
      1,
      3.399624,
      3,
      2.448470,
      2,
      3.938003,
      0,
      3.503402,
      0.558129,
      NULL,
      1,
      NULL,
      NULL,
      1.281587,
      NULL,
      NULL,
      9,
      1,
      3.984820,
      0.584810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555167,
      1.589406,
      1.896132,
      2.989212,
      0,
      NULL,
      2.884345,
      1.139541,
      NULL,
      NULL,
      1.937843,
      NULL,
      NULL,
      1.680217,
      NULL,
      1.892351,
      3,
      2.299914,
      NULL,
      0.283318,
      0.979806,
      0,
      1,
      NULL,
      0.297252,
      1.797676,
      0.045138,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.560716,
      0,
      1.334731,
      0,
      0,
      5,
      0,
      0.987964,
      0,
      5.501550,
      1,
      NULL,
      1.511770,
      2,
      1,
      1,
      5,
      3,
      NULL,
      0.673596,
      2.218760,
      NULL,
      3,
      3,
      2.251572,
      NULL,
      NULL,
      3,
      0.551316,
      0,
      1,
      1.776247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999337,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1.174035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809666,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.589412,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      2.020960,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.056579,
      0.412531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      0,
      NULL,
      2.917357,
      NULL,
      0.648668,
      2.884604,
      1.220144,
      1,
      1,
      1.714821,
      1,
      1.099328,
      1.824339,
      1.185540,
      0,
      1.078431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.323220,
      NULL,
      NULL,
      '',
      1.421939,
      '',
      '',
      NULL,
      0.149210,
      NULL,
      '',
      '',
      2,
      3,
      3.842070,
      2.442977,
      0,
      NULL,
      6,
      NULL,
      NULL);
commit;
end;
/


