set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '20034400',
      65.776423,
      48,
      '3031230',
      74,
      0,
      0.563006,
      3,
      '102423',
      3,
      NULL,
      31.607403,
      38,
      0.032692,
      NULL,
      0.219900,
      NULL,
      1.821028,
      1.412152,
      NULL,
      1.906035,
      3.888404,
      NULL,
      NULL,
      0.841157,
      7,
      1,
      1.896299,
      0.574775,
      1.221454,
      NULL,
      9,
      NULL,
      3,
      NULL,
      0.801362,
      3,
      NULL,
      1,
      2,
      5.311766,
      1.234156,
      0,
      NULL,
      NULL,
      1.919143,
      NULL,
      NULL,
      2.023918,
      0,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3.738788,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      1,
      2,
      1.102277,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.401786,
      1,
      3,
      NULL,
      2,
      0,
      0.920513,
      0,
      0.303649,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0.770881,
      1,
      0.553530,
      NULL,
      1,
      3.059897,
      0.043836,
      0.402469,
      NULL,
      NULL,
      6.348197,
      NULL,
      1,
      NULL,
      0,
      3,
      5.580229,
      0.536694,
      2.167670,
      0.501229,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      5,
      4,
      8.625741,
      1.942872,
      NULL,
      2,
      NULL,
      0.279876,
      NULL,
      2,
      1.292887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.975396,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.086445,
      3.133308,
      0.810397,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.380621,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.687564,
      3.752268,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.802552,
      2,
      1,
      NULL,
      0,
      3,
      NULL,
      2,
      2.783171,
      1.335096,
      1,
      0.074785,
      0,
      0,
      0,
      1,
      0.474985,
      NULL,
      0.185278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.771014,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2,
      2.828298,
      0.722903,
      NULL,
      NULL,
      3.559007,
      2.391447,
      1.239063,
      NULL);
commit;
end;
/


