set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3222',
      '03333041',
      48.568134,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '310320',
      NULL,
      NULL,
      NULL,
      NULL,
      0.934242,
      NULL,
      1,
      1,
      1.867963,
      1.687617,
      1,
      2.363202,
      0.512027,
      0,
      0.170199,
      0.931206,
      7,
      1.142685,
      0.965583,
      8.293537,
      2,
      NULL,
      NULL,
      1,
      3.086771,
      1,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      2,
      1.862892,
      NULL,
      NULL,
      1.521945,
      NULL,
      NULL,
      9.333792,
      2.057797,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      6.336175,
      0,
      0,
      2.957070,
      1,
      NULL,
      NULL,
      1.013238,
      NULL,
      NULL,
      0.772211,
      NULL,
      0.001703,
      2.136905,
      3.660390,
      NULL,
      1.425945,
      0.727400,
      1,
      NULL,
      NULL,
      4,
      1,
      3.857312,
      1.025067,
      1,
      1.338298,
      0,
      1.248545,
      NULL,
      1,
      NULL,
      1.694948,
      1,
      NULL,
      0.237362,
      NULL,
      1.647722,
      0.275150,
      4.242625,
      1.880682,
      5,
      2,
      2.773208,
      1,
      0,
      1,
      6,
      5.185416,
      3.815143,
      3,
      5.575463,
      0,
      7,
      5.645181,
      4.038302,
      NULL,
      2,
      3,
      1,
      1.658435,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821480,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1.196886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770337,
      NULL,
      NULL,
      NULL,
      NULL,
      4.666532,
      0.408674,
      NULL,
      1,
      NULL,
      0.864119,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.018814,
      NULL,
      1.895369,
      0.307606,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.509146,
      2.009144,
      1,
      2.672926,
      NULL,
      3.104449,
      3.120586,
      NULL,
      2,
      0.268185,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0.527328,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.917733,
      NULL,
      '',
      '',
      2,
      2,
      1,
      NULL,
      0.589469,
      1,
      2.560783,
      0.331162,
      NULL);
commit;
end;
/


