set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24424312',
      NULL,
      26.990831,
      '4322404',
      1.803326,
      0,
      2.051279,
      1,
      '312440',
      3.956380,
      ' 3- 0-1978',
      0.494542,
      146,
      1,
      NULL,
      0.898647,
      0,
      0,
      0.845649,
      0.139041,
      2.008224,
      1.085749,
      1.403626,
      0.964768,
      1,
      7,
      1,
      1.445167,
      NULL,
      NULL,
      1.638989,
      4,
      1.571340,
      1,
      0.121573,
      0.975695,
      0,
      4.386129,
      NULL,
      NULL,
      NULL,
      0.165895,
      1.541586,
      NULL,
      NULL,
      0.275516,
      NULL,
      NULL,
      4,
      7,
      0.470362,
      0.644248,
      1.433788,
      NULL,
      NULL,
      3,
      0.027646,
      NULL,
      0,
      2,
      1.332221,
      2.809763,
      1,
      0,
      0.607103,
      2.101646,
      1.421410,
      NULL,
      1.748736,
      1.561370,
      2,
      0,
      2,
      1.739374,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.812200,
      4,
      1.889308,
      0.698810,
      4.968760,
      NULL,
      7.479754,
      0.633246,
      5.578550,
      5.674701,
      1,
      0.622698,
      0.458201,
      5,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.321097,
      2.911014,
      7.876509,
      NULL,
      1.792302,
      7,
      0,
      0.544289,
      0.405697,
      3.493289,
      1,
      4,
      NULL,
      0.662030,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.815623,
      5,
      5,
      NULL,
      8,
      0.123022,
      NULL,
      NULL,
      3.025195,
      3.358412,
      0.642432,
      0.991400,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.112714,
      1.297529,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.910715,
      1.070695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464804,
      1.933575,
      3.593896,
      0,
      1.156832,
      NULL,
      2.548029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.323905,
      NULL,
      1.281476,
      0.267782,
      1,
      1,
      3.946309,
      0.576810,
      0.930156,
      0,
      1.253818,
      1.407499,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.482739,
      '',
      '',
      '',
      4,
      5,
      3,
      2,
      3,
      3,
      1,
      NULL,
      NULL);
commit;
end;
/


