set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '14200310',
      58.438361,
      67.804580,
      '2301311',
      9.349782,
      3,
      1,
      3,
      NULL,
      3.659751,
      '11- 8-1974',
      6.861267,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.723227,
      1.643012,
      0,
      1,
      0,
      NULL,
      0.448127,
      2,
      0.156582,
      1,
      5.387358,
      0,
      1,
      NULL,
      0,
      NULL,
      1.545790,
      1,
      0.263758,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.905086,
      1.170886,
      NULL,
      3.445698,
      0.308892,
      NULL,
      3,
      2.606647,
      0.021728,
      1.323246,
      0.960313,
      2,
      0,
      3.928441,
      1.515112,
      1,
      3,
      3.666307,
      0,
      NULL,
      1.581090,
      2,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.590607,
      1,
      NULL,
      0.544622,
      3,
      NULL,
      1.690244,
      2.594831,
      1.907300,
      NULL,
      NULL,
      6,
      0,
      1.472719,
      0.478976,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      2.326609,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      1.514376,
      2,
      NULL,
      6,
      0,
      4,
      3,
      3.143785,
      1.181113,
      9,
      3,
      7.908080,
      9,
      3,
      0,
      0,
      1,
      3.223105,
      0,
      0,
      3.062041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.780608,
      0,
      0,
      1,
      1.373073,
      1,
      1.966474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.360507,
      NULL,
      NULL,
      1,
      0.537053,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.736853,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      9.369324,
      5,
      1.072435,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.435433,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441387,
      2,
      NULL,
      0,
      1.638212,
      3,
      0.634136,
      0.964701,
      0,
      3.272744,
      3,
      0.504306,
      NULL,
      1.420980,
      1.086349,
      1.669343,
      1,
      1.362646,
      1.708635,
      1.087710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.119005,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.866760,
      NULL,
      NULL,
      NULL,
      1.581472,
      NULL,
      0.670414,
      1,
      2,
      7.265264,
      NULL,
      2,
      1);
commit;
end;
/


