set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4234',
      NULL,
      9,
      38,
      '1244442',
      NULL,
      3,
      1.493584,
      NULL,
      '123443',
      0,
      NULL,
      21,
      31.066887,
      1,
      NULL,
      3.315066,
      1,
      3,
      1,
      1,
      NULL,
      1,
      2.810257,
      0.308055,
      1,
      2.597972,
      0.120966,
      3.712948,
      6,
      0,
      1.868795,
      3.762869,
      0,
      2.345933,
      NULL,
      1.211704,
      1,
      NULL,
      NULL,
      0,
      2,
      1.967088,
      1.303426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      1,
      0,
      1.204720,
      NULL,
      1.136648,
      0.033986,
      1,
      0,
      1,
      1,
      1.135409,
      0.406945,
      3,
      0.844577,
      0,
      1,
      0.006456,
      4,
      3.399023,
      0,
      0,
      4.169520,
      0,
      NULL,
      NULL,
      1.177642,
      NULL,
      NULL,
      1,
      0.527673,
      5.160323,
      0.750903,
      3.102273,
      1,
      4,
      1.877063,
      1.222881,
      1,
      1.489573,
      1,
      0,
      2.457017,
      0,
      NULL,
      NULL,
      0,
      1.816909,
      NULL,
      0,
      7.975058,
      3.234089,
      1.872835,
      0.075921,
      NULL,
      NULL,
      1.905468,
      NULL,
      1.776906,
      3,
      1,
      3.646673,
      3.308112,
      1,
      1.209708,
      2,
      NULL,
      1,
      2,
      6.897814,
      11.858080,
      6.087037,
      1,
      6,
      0,
      NULL,
      3,
      2.400267,
      1.363430,
      1.978565,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.243014,
      0,
      2,
      NULL,
      1.741472,
      0.306314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730164,
      NULL,
      6.917742,
      2,
      1.033365,
      2.523116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.025958,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.974617,
      8.575991,
      3,
      1,
      0.336936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924177,
      0.664151,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.600159,
      1,
      0.964769,
      2,
      NULL,
      NULL,
      0.470193,
      0.404287,
      1,
      1.804667,
      1.657897,
      0.828835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '43232',
      '',
      '',
      1.564422,
      '',
      '',
      '',
      0.398433,
      '',
      '',
      '',
      4,
      NULL,
      7,
      2.831283,
      2,
      1,
      7,
      3,
      3.152102);
commit;
end;
/


