set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2313',
      '14300223',
      40.596814,
      8.158623,
      '2321043',
      2,
      5,
      3,
      3,
      '300244',
      3,
      ' 5-25-1981',
      56.897252,
      56,
      1,
      NULL,
      1.302397,
      1.931738,
      3,
      0.885123,
      1,
      1,
      1,
      3.853332,
      NULL,
      1,
      7,
      1.376646,
      NULL,
      8.453320,
      5.099015,
      1,
      2,
      1.407934,
      5,
      0.260772,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235850,
      1,
      NULL,
      NULL,
      1.019347,
      NULL,
      NULL,
      2.735053,
      NULL,
      3,
      3,
      NULL,
      1,
      3,
      2,
      1,
      0,
      1,
      1,
      0.941744,
      3,
      0.685267,
      0,
      3,
      2,
      2.403492,
      0.055101,
      1,
      0,
      5.249404,
      0,
      2,
      0,
      0.483249,
      NULL,
      NULL,
      0.926647,
      NULL,
      NULL,
      0,
      NULL,
      4.089505,
      1,
      4,
      1.657870,
      3,
      0,
      3,
      NULL,
      1.532743,
      1,
      0.332905,
      NULL,
      0,
      0,
      1,
      1,
      1.266981,
      NULL,
      NULL,
      2,
      5,
      NULL,
      1,
      NULL,
      0.418102,
      1.122357,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      3,
      0.341898,
      2,
      7.956816,
      1,
      4,
      2.230592,
      NULL,
      4.354105,
      8,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454798,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.956756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.636977,
      1.887259,
      NULL,
      2.446776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.948755,
      0.734910,
      NULL,
      NULL,
      NULL,
      1,
      3,
      6.505503,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.736394,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.336940,
      1.505589,
      0,
      3,
      3.800442,
      NULL,
      1,
      NULL,
      1,
      1,
      1.068779,
      0.011790,
      1.113972,
      NULL,
      1,
      0,
      1.764350,
      1.175647,
      0.628327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1.235811,
      '',
      '',
      '',
      NULL,
      3,
      0.143730,
      2.169457,
      1.262444,
      0,
      0.599090,
      3,
      3.801403);
commit;
end;
/


